<?php
// api/copy_document.php
require_once '../includes/functions.php';
requireLogin();
require_once '../config/db.php';

header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit();
}

// CSRF token validation
if (!isset($_POST['csrf_token']) || !verifyToken($_POST['csrf_token'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid CSRF token.']);
    exit();
}

$document_id = isset($_POST['document_id']) ? intval($_POST['document_id']) : 0;
$version = isset($_POST['version']) ? intval($_POST['version']) : 0;

if ($document_id <= 0 || $version <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid document information.']);
    exit();
}

// Verify the document belongs to the current user
$stmt = $pdo->prepare("SELECT * FROM documents WHERE id = ? AND user_id = ?");
$stmt->execute([$document_id, getCurrentUserId()]);
$doc = $stmt->fetch();
if (!$doc) {
    echo json_encode(['success' => false, 'message' => 'Document not found or access denied.']);
    exit();
}

// Retrieve the content of the specified version
$stmt = $pdo->prepare("SELECT content FROM versions WHERE document_id = ? AND version = ?");
$stmt->execute([$document_id, $version]);
$versionData = $stmt->fetch();
if (!$versionData) {
    echo json_encode(['success' => false, 'message' => 'Version not found.']);
    exit();
}

// Create a new document as a branch/copy of the existing version
$newTitle = $doc['title'] . " (Copy)";
$stmt = $pdo->prepare("INSERT INTO documents (user_id, title, current_version, created_at, updated_at) VALUES (?, ?, 1, NOW(), NOW())");
$stmt->execute([getCurrentUserId(), $newTitle]);
$newDocumentId = $pdo->lastInsertId();

// Insert the new document’s first version
$stmt = $pdo->prepare("INSERT INTO versions (document_id, version, content, status, created_at) VALUES (?, 1, ?, 'unsaved', NOW())");
$stmt->execute([$newDocumentId, $versionData['content']]);

echo json_encode(['success' => true, 'new_document_id' => $newDocumentId, 'new_version' => 1]);
exit();
