<?php
/*
  api/create_document.php
  Final Version: 2025-02-11

  Accepts optional version_label to set doc's first version to e.g. '(autosave)' or '1.1'.
  If not given, we use '1'.
*/

require_once '../includes/functions.php';
requireLogin();
require_once '../config/db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success'=>false,'message'=>'Invalid request method.']);
    exit();
}
if(!isset($_POST['csrf_token'])||!verifyToken($_POST['csrf_token'])){
    echo json_encode(['success'=>false,'message'=>'Invalid CSRF token.']);
    exit();
}

$title = isset($_POST['title']) ? trim($_POST['title']) : 'Untitled';
$content= isset($_POST['content'])? $_POST['content']: '';
$version_label= isset($_POST['version_label']) ? trim($_POST['version_label']) : '';
if($version_label===''){
    $version_label='1';
}
$user_id=getCurrentUserId();

try{
    $stmtDoc=$pdo->prepare("
      INSERT INTO documents(user_id, title, current_version, created_at, updated_at)
      VALUES(?,?,?,?,NOW())
    ");
    // Oops, we need 5 placeholders, let's fix:
    // Actually let's do: INSERT INTO documents (user_id, title, current_version, created_at, updated_at)
    // "VALUES (?, ?, ?, NOW(), NOW())"
    $stmtDoc=$pdo->prepare("
      INSERT INTO documents (user_id, title, current_version, created_at, updated_at)
      VALUES (?, ?, ?, NOW(), NOW())
    ");
    $stmtDoc->execute([$user_id, $title, $version_label]);
    $document_id = $pdo->lastInsertId();

    $stmtVer=$pdo->prepare("
      INSERT INTO versions (document_id, version, content, status, created_at)
      VALUES (?, ?, ?, 'unsaved', NOW())
    ");
    $stmtVer->execute([$document_id,$version_label,$content]);

    echo json_encode([
        'success'=>true,
        'document_id'=>$document_id,
        'version'=>$version_label,
        'title'=>$title
    ]);
    exit();

}catch(Exception $ex){
    echo json_encode(['success'=>false,'message'=>'Error creating doc: '.$ex->getMessage()]);
    exit();
}
