<?php
// api/delete_document.php
require_once '../includes/functions.php';
requireLogin();
require_once '../config/db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit();
}

if (!isset($_POST['csrf_token']) || !verifyToken($_POST['csrf_token'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid CSRF token.']);
    exit();
}

$document_id = isset($_POST['document_id']) ? intval($_POST['document_id']) : 0;
$delete_main = isset($_POST['delete_main']) ? boolval($_POST['delete_main']) : false;

if ($document_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid document information.']);
    exit();
}

// Verify the document belongs to the current user
$stmt = $pdo->prepare("SELECT id FROM documents WHERE id = ? AND user_id = ?");
$stmt->execute([$document_id, getCurrentUserId()]);
if (!$stmt->fetch()) {
    echo json_encode(['success' => false, 'message' => 'Document not found or access denied.']);
    exit();
}

if ($delete_main) {
    // Delete all versions associated with the document
    $stmt = $pdo->prepare("DELETE FROM versions WHERE document_id = ?");
    $stmt->execute([$document_id]);
    // Delete the document record
    $stmt = $pdo->prepare("DELETE FROM documents WHERE id = ?");
    $stmt->execute([$document_id]);
    echo json_encode(['success' => true]);
    exit();
}

// Otherwise, delete a specific version. Expect a version_id.
$version_id = isset($_POST['version_id']) ? intval($_POST['version_id']) : 0;
if ($version_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid version information.']);
    exit();
}

// Retrieve version details
$stmt = $pdo->prepare("SELECT version FROM versions WHERE id = ? AND document_id = ?");
$stmt->execute([$version_id, $document_id]);
$versionData = $stmt->fetch();
if (!$versionData) {
    echo json_encode(['success' => false, 'message' => 'Version not found.']);
    exit();
}

// Prevent deletion of the current version
$stmt = $pdo->prepare("SELECT current_version FROM documents WHERE id = ?");
$stmt->execute([$document_id]);
$doc = $stmt->fetch();
if ($doc['current_version'] == $versionData['version']) {
    echo json_encode(['success' => false, 'message' => 'Cannot delete the current version.']);
    exit();
}

// Delete the specified version
$stmt = $pdo->prepare("DELETE FROM versions WHERE id = ? AND document_id = ?");
$stmt->execute([$version_id, $document_id]);

echo json_encode(['success' => true]);
exit();
