<?php
// api/get_history.php
require_once '../includes/functions.php';
requireLogin();
require_once '../config/db.php';

header('Content-Type: application/json');

$document_id = isset($_GET['document_id']) ? intval($_GET['document_id']) : 0;
if ($document_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid document information.']);
    exit();
}

// Verify the document belongs to the current user
$stmt = $pdo->prepare("SELECT current_version FROM documents WHERE id = ? AND user_id = ?");
$stmt->execute([$document_id, getCurrentUserId()]);
$doc = $stmt->fetch();
if (!$doc) {
    echo json_encode(['success' => false, 'message' => 'Document not found or access denied.']);
    exit();
}

// Retrieve all versions for this document
$stmt = $pdo->prepare("SELECT id, version, content, status, DATE_FORMAT(created_at, '%m/%d/%Y : %l:%i %p') as saved_at FROM versions WHERE document_id = ? ORDER BY version DESC");
$stmt->execute([$document_id]);
$versions = $stmt->fetchAll();

$versionsArray = [];
foreach ($versions as $v) {
    $versionsArray[] = [
        'id' => $v['id'],
        'version' => $v['version'],
        'status' => $v['status'],
        'saved_at' => $v['saved_at'],
        'is_current' => ($v['version'] == $doc['current_version'])
    ];
}

echo json_encode(['success' => true, 'versions' => $versionsArray]);
exit();
