<?php
// api/update_document_title.php
require_once '../includes/functions.php';
requireLogin();
require_once '../config/db.php';

header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit();
}

// CSRF token validation
if (!isset($_POST['csrf_token']) || !verifyToken($_POST['csrf_token'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid CSRF token.']);
    exit();
}

$document_id = isset($_POST['document_id']) ? intval($_POST['document_id']) : 0;
$title = isset($_POST['title']) ? trim($_POST['title']) : '';

if ($document_id <= 0 || empty($title)) {
    echo json_encode(['success' => false, 'message' => 'Invalid document ID or title.']);
    exit();
}

// Verify the document belongs to the current user
$stmt = $pdo->prepare("SELECT id FROM documents WHERE id = ? AND user_id = ?");
$stmt->execute([$document_id, getCurrentUserId()]);
if (!$stmt->fetch()) {
    echo json_encode(['success' => false, 'message' => 'Document not found or access denied.']);
    exit();
}

// Update the document title
$stmt = $pdo->prepare("UPDATE documents SET title = ?, updated_at = NOW() WHERE id = ?");
if ($stmt->execute([$title, $document_id])) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update title.']);
}
exit();
