<?php
// login.php
require_once 'includes/functions.php';
require_once 'config/db.php';

$page_title = "Login - Web Code Editor";

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF check
    if (!isset($_POST['csrf_token']) || !verifyToken($_POST['csrf_token'])) {
        $errors[] = "Invalid CSRF token.";
    } else {
        $email = trim($_POST['email']);
        $password = $_POST['password'];
        
        if (empty($email) || empty($password)) {
            $errors[] = "Please fill in all fields.";
        } else {
            $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
            $stmt->execute([$email]);
            $user = $stmt->fetch();
            if ($user && password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                header("Location: editor.php");
                exit();
            } else {
                $errors[] = "Invalid email or password.";
            }
        }
    }
}

// Demo account auto login (if query parameter demo=1)
if (isset($_GET['demo']) && $_GET['demo'] == 1) {
    $demoEmail = "demo@demo.com";
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$demoEmail]);
    $user = $stmt->fetch();
    if (!$user) {
        $demoPassword = password_hash("demo123", PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO users (email, password) VALUES (?, ?)");
        $stmt->execute([$demoEmail, $demoPassword]);
        $userId = $pdo->lastInsertId();
    } else {
        $userId = $user['id'];
    }
    $_SESSION['user_id'] = $userId;
    header("Location: editor.php");
    exit();
}

include 'includes/header.php';
?>
<div class="container mt-5">
    <h2 class="mb-4">Login to Web Code Editor</h2>
    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <?php foreach ($errors as $error) {
                echo "<p>" . escape($error) . "</p>";
            } ?>
        </div>
    <?php endif; ?>
    <form method="POST" action="login.php">
        <input type="hidden" name="csrf_token" value="<?php echo generateToken(); ?>">
        <div class="mb-3">
            <label for="email" class="form-label">Email address</label>
            <input type="email" class="form-control" id="email" name="email" placeholder="Enter email" required>
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="password" class="form-control" id="password" name="password" placeholder="Enter password" required>
        </div>
        <button type="submit" class="btn btn-primary">Login</button>
        <a href="signup.php" class="btn btn-link">Sign Up</a>
        <a href="login.php?demo=1" class="btn btn-secondary">Demo Account</a>
    </form>
</div>
<?php include 'includes/footer.php'; ?>
