<?php
// signup.php
require_once 'includes/functions.php';
require_once 'config/db.php';

$page_title = "Sign Up - Web Code Editor";

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF check
    if (!isset($_POST['csrf_token']) || !verifyToken($_POST['csrf_token'])) {
        $errors[] = "Invalid CSRF token.";
    } else {
        $email = trim($_POST['email']);
        $password = $_POST['password'];
        $confirm_password = $_POST['confirm_password'];

        if (empty($email) || empty($password) || empty($confirm_password)) {
            $errors[] = "Please fill in all fields.";
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $errors[] = "Invalid email address.";
        } elseif ($password !== $confirm_password) {
            $errors[] = "Passwords do not match.";
        } else {
            // Check if the email already exists
            $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
            $stmt->execute([$email]);
            if ($stmt->fetch()) {
                $errors[] = "Email already registered.";
            } else {
                $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("INSERT INTO users (email, password) VALUES (?, ?)");
                if ($stmt->execute([$email, $hashedPassword])) {
                    $_SESSION['user_id'] = $pdo->lastInsertId();
                    header("Location: editor.php");
                    exit();
                } else {
                    $errors[] = "Error creating account. Please try again.";
                }
            }
        }
    }
}

include 'includes/header.php';
?>
<div class="container mt-5">
    <h2 class="mb-4">Sign Up for Web Code Editor</h2>
    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <?php foreach ($errors as $error) {
                echo "<p>" . escape($error) . "</p>";
            } ?>
        </div>
    <?php endif; ?>
    <form method="POST" action="signup.php">
        <input type="hidden" name="csrf_token" value="<?php echo generateToken(); ?>">
        <div class="mb-3">
            <label for="email" class="form-label">Email address</label>
            <input type="email" class="form-control" id="email" name="email" placeholder="Enter email" required>
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">Password (min 6 characters)</label>
            <input type="password" class="form-control" id="password" name="password" placeholder="Enter password" required minlength="6">
        </div>
        <div class="mb-3">
            <label for="confirm_password" class="form-label">Confirm Password</label>
            <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="Confirm password" required minlength="6">
        </div>
        <button type="submit" class="btn btn-primary">Sign Up</button>
        <a href="login.php" class="btn btn-link">Already have an account? Login</a>
    </form>
</div>
<?php include 'includes/footer.php'; ?>
