<?php
// recovery.php
// This script lists all documents (and their current version content) for recovery purposes.
require_once 'includes/functions.php';
require_once 'config/db.php';

// Ensure the user is logged in.
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Query to get documents along with their current version details.
$stmt = $pdo->prepare("
    SELECT d.id, d.title, d.current_version, d.updated_at, v.content
    FROM documents d
    JOIN versions v ON d.id = v.document_id AND v.version = d.current_version
    WHERE d.user_id = ?
    ORDER BY d.updated_at DESC
");
$stmt->execute([$user_id]);
$documents = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Recovery - Document List</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        pre {
            white-space: pre-wrap;
            word-wrap: break-word;
            background-color: #f8f9fa;
            padding: 10px;
            border: 1px solid #ddd;
        }
    </style>
</head>
<body>
<div class="container mt-4">
    <h2>Recovery - Document List</h2>
    <p>This page lists all documents stored in the database for your account. If a document “disappeared” from the editor, you can use this list to recover its content.</p>
    <?php if(count($documents) > 0): ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Document ID</th>
                <th>Title</th>
                <th>Current Version</th>
                <th>Last Updated</th>
                <th>View Content</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($documents as $doc): ?>
            <tr>
                <td><?php echo htmlspecialchars($doc['id']); ?></td>
                <td><?php echo htmlspecialchars($doc['title']); ?></td>
                <td><?php echo htmlspecialchars($doc['current_version']); ?></td>
                <td><?php echo htmlspecialchars($doc['updated_at']); ?></td>
                <td>
                    <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#viewContentModal<?php echo $doc['id']; ?>">View</button>
                    <!-- Modal for viewing document content -->
                    <div class="modal fade" id="viewContentModal<?php echo $doc['id']; ?>" tabindex="-1" aria-labelledby="viewContentModalLabel<?php echo $doc['id']; ?>" aria-hidden="true">
                      <div class="modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="viewContentModalLabel<?php echo $doc['id']; ?>">Document Content - <?php echo htmlspecialchars($doc['title']); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <div class="modal-body">
                            <pre><?php echo htmlspecialchars($doc['content']); ?></pre>
                          </div>
                        </div>
                      </div>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php else: ?>
        <p>No documents found in the database.</p>
    <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
